// 計算機.js
// ----------------------------------------------------
// Copyright (c) 2015 Trb
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------
/*:
 *
 * @plugindesc 各種計算プラグイン
 * @author Trb
 * 
 * @help イベントコマンドで行うと長くなってしまう計算を簡略化するプラグインです。
 * このプラグインはプラグインコマンドでなくスクリプトコマンドで実行する形式になってます。
 * それによって変数の操作や条件分岐などにも使うことができます。
 *
 * <スクリプトコマンド一覧>
 * kyori_A(a,b)　・・・イベントaとイベントbの間の距離を求めます。0を代入するとプレイヤーの座標になります。
 * 例　プレイヤーとイベントID 3番との間の距離を求めたい時　kyori_A(0,3) と書く
 *　条件分岐で　kyori_E(0,3) < 50 と書けばプレイヤーとイベント3との距離が50未満の時、といった分岐条件に使ったりできます。
 *
 * kyori_B(ax,ay,bx,by)　・・・上のものと基本的には同じですが、2点の座標を指定して距離を求めます。
 * ピクチャーを使った演出をしていてピクチャー座標との距離を求めたい時などはこちらを使ってください。
 * 例　座標(10,15)と座標(20,25)の間の距離を求めたい時　kyori_B(10,15,20,25)と書く
 *
 *
 * kaku_A(a,b) ・・・イベントaとイベントbの間の角度を求めます。これも0を入れるとプレイヤーを指します。
 * a側が基準で、真右が0度、そこから時計回りに増えていきます。
 * 
 * kaku_A2(a,b)　・・・イベントaとイベントbの間の角度を求めるのは同じですが、上の関数は常に真右を基準にするのに対して
 * こちらはイベントaが向いている方向を基準にした角度を求められます。
 * タイルチップなど向きのないイベントの場合は真下が基準になります。
 * 
 * kaku_B(ax,ay,bx,by)　・・・kyori_Bと同じように2点の座標間の角度を求めます。
 * 
 * region_F(a,b)　・・・イベントaの b歩前のリージョン番号を取得します。
 * 例　プレイヤーの現在地の1歩前のリージョン番号を取得したい時　region_F(0,1)と書く
 * (1歩前というのは向いている向きに対して1マス先という意味です)
 * 
 */
(function () {
	
//-------------------------
	kyori_A = function(a,b){
		
		a = Math.round(a);
		b = Math.round(b);
		
		if(a <= 0){
			var ax = $gamePlayer.screenX();
			var ay = $gamePlayer.screenY();			
		}
		else{
			var ax = $gameMap.events()[a-1].screenX();
			var ay = $gameMap.events()[a-1].screenY();						
		};
		
		if(b <= 0){
			var bx = $gamePlayer.screenX();
			var by = $gamePlayer.screenY();			
		}
		else{
			var bx = $gameMap.events()[b-1].screenX();
			var by = $gameMap.events()[b-1].screenY();						
		};
		
		var x = Math.abs(ax-bx);
		var y = Math.abs(ay-by);
		
		return Math.sqrt(x * x + y * y);
	};

//--------------------------
	kyori_B = function(ax,ay,bx,by){
		var x = Math.abs(ax-bx);
		var y = Math.abs(ay-by);		
		return Math.sqrt(x * x + y * y);
	};

//--------------------------
	kaku_A = function(a,b){
		a = Math.round(a);
		b = Math.round(b);
		
		if(a <= 0){
			var ax = $gamePlayer.screenX();
			var ay = $gamePlayer.screenY();			
		}
		else{
			var ax = $gameMap.events()[a-1].screenX();
			var ay = $gameMap.events()[a-1].screenY();						
		};
		
		if(b <= 0){
			var bx = $gamePlayer.screenX();
			var by = $gamePlayer.screenY();			
		}
		else{
			var bx = $gameMap.events()[b-1].screenX();
			var by = $gameMap.events()[b-1].screenY();						
		};
		
		var x = bx-ax;
		var y = by-ay;		
		
		var k = Math.atan2(y,x) * 180 / Math.PI;
		return k;
	};
//-------------------------
    kaku_A2 = function(a,b){
		var k = kaku_A(a,b);
		a = Math.round(a);
		if(a <= 0){
			var di = $gamePlayer.direction();
		}
		else{
			var di = $gameMap.events()[a-1].direction();
		}
		if(di == 2)k -= 90;
		if(di == 4)k -= 180;
		if(di == 8)k -= 270;
		if(k < -180)k += 360;
		return k;
	};
//--------------------------
	kaku_B = function(ax,ay,bx,by){
		var x = bx-ax;
		var y = by-ay;		
		
		var k = Math.atan2(y,x) * 180 / Math.PI;
		if(k < -180)k += 360;
		return k;		
		
	};
//---------------------------
	region_F = function(a,b){
		a = Math.round(a);
		b = Math.round(b);
		if(a <= 0){
			var ax = $gamePlayer._realX;
			var ay = $gamePlayer._realY;
			var di = $gamePlayer.direction();			
		}
		else{
			var ax = $gameMap.events()[a-1]._realX;
			var ay = $gameMap.events()[a-1]._realY;	
			var di = $gameMap.events()[a-1].direction();					
		};		

		if(di == 2)ay += b;
		if(di == 4)ax -= b;
		if(di == 6)ax += b;
		if(di == 8)ay -= b;
		
		return $gameMap.regionId(ax, ay);
	};

})();